/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.Assignment;
import com.mckoi.database.DataTable;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.QueryContext;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.StatementTree;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.TableQueryDef;
import com.mckoi.database.TriggerEvent;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.Variable;
import com.mckoi.database.interpret.FromTableDirectSource;
import com.mckoi.database.interpret.Select;
import com.mckoi.database.interpret.Statement;
import com.mckoi.util.IntegerVector;
import java.util.ArrayList;
import java.util.List;

public class Insert
extends Statement {
    String table_name;
    ArrayList col_list;
    ArrayList values_list;
    StatementTree select;
    ArrayList column_sets;
    boolean from_values = false;
    boolean from_select = false;
    boolean from_set = false;
    private DataTable insert_table;
    private int[] col_index_list;
    private Variable[] col_var_list;
    private TableName tname;
    private Select prepared_select;
    private ArrayList relationally_linked_tables;

    public void prepare() throws DatabaseException {
        this.table_name = (String)this.cmd.getObject("table_name");
        this.col_list = (ArrayList)this.cmd.getObject("col_list");
        this.values_list = (ArrayList)this.cmd.getObject("data_list");
        this.select = (StatementTree)this.cmd.getObject("select");
        this.column_sets = (ArrayList)this.cmd.getObject("assignments");
        String type = (String)this.cmd.getObject("type");
        this.from_values = type.equals("from_values");
        this.from_select = type.equals("from_select");
        this.from_set = type.equals("from_set");
        int first_len = -1;
        for (int n = 0; n < this.values_list.size(); ++n) {
            List exp_list = (List)this.values_list.get(n);
            if (first_len != -1 && first_len != exp_list.size()) {
                throw new DatabaseException("The insert data list varies in size.");
            }
            first_len = exp_list.size();
        }
        this.tname = this.resolveTableName(this.table_name, this.database);
        if (!this.database.tableExists(this.tname)) {
            throw new DatabaseException("Table '" + this.tname + "' does not exist.");
        }
        TableQueryDef table_query_def = this.database.getTableQueryDef(this.tname, null);
        this.addTable(new FromTableDirectSource(this.database, table_query_def, "INSERT_TABLE", this.tname, this.tname));
        this.insert_table = this.database.getTable(this.tname);
        if (this.from_values || this.from_select) {
            if (this.col_list.size() == 0) {
                for (int i = 0; i < this.insert_table.getColumnCount(); ++i) {
                    this.col_list.add(this.insert_table.getColumnDefAt(i).getName());
                }
            }
            this.col_index_list = new int[this.col_list.size()];
            this.col_var_list = new Variable[this.col_list.size()];
            for (int i = 0; i < this.col_list.size(); ++i) {
                Variable in_var = Variable.resolve((String)this.col_list.get(i));
                Variable col = this.resolveColumn(in_var);
                int index = this.insert_table.fastFindFieldName(col);
                if (index == -1) {
                    throw new DatabaseException("Can't find column: " + col);
                }
                this.col_index_list[i] = index;
                this.col_var_list[i] = col;
            }
        }
        if (this.from_values) {
            if (this.col_list.size() != ((List)this.values_list.get(0)).size()) {
                throw new DatabaseException("Number of columns to insert is different from columns selected to insert to.");
            }
            for (int i = 0; i < this.values_list.size(); ++i) {
                List insert_elements = (List)this.values_list.get(i);
                int sz = insert_elements.size();
                for (int n = 0; n < sz; ++n) {
                    Object elem = insert_elements.get(n);
                    if (!(elem instanceof Expression)) continue;
                    Expression exp = (Expression)elem;
                    List elem_list = exp.allElements();
                    for (int p = 0; p < elem_list.size(); ++p) {
                        Object ob = elem_list.get(p);
                        if (!(ob instanceof Select)) continue;
                        throw new DatabaseException("Illegal to have sub-select in expression.");
                    }
                    this.resolveExpression(exp);
                }
            }
        } else if (this.from_select) {
            this.prepared_select = new Select();
            this.prepared_select.init(this.database, this.select, null);
            this.prepared_select.prepare();
        } else if (this.from_set) {
            for (int i = 0; i < this.column_sets.size(); ++i) {
                Assignment assignment = (Assignment)this.column_sets.get(i);
                Expression exp = assignment.getExpression();
                List elem_list = exp.allElements();
                for (int n = 0; n < elem_list.size(); ++n) {
                    Object ob = elem_list.get(n);
                    if (!(ob instanceof Select)) continue;
                    throw new DatabaseException("Illegal to have sub-select in SET clause.");
                }
                Variable v = assignment.getVariable();
                Variable resolved_v = this.resolveVariableName(v);
                v.set(resolved_v);
                this.resolveExpression(assignment.getExpression());
            }
        }
        TableName[] linked_tables = this.database.queryTablesRelationallyLinkedTo(this.tname);
        this.relationally_linked_tables = new ArrayList(linked_tables.length);
        for (int i = 0; i < linked_tables.length; ++i) {
            this.relationally_linked_tables.add(this.database.getTable(linked_tables[i]));
        }
    }

    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        if (!this.database.getDatabase().canUserInsertIntoTableObject(context, this.user, this.tname, this.col_var_list)) {
            throw new UserAccessException("User not permitted to insert in to table: " + this.table_name);
        }
        int insert_count = 0;
        if (this.from_values) {
            for (int i = 0; i < this.values_list.size(); ++i) {
                List insert_elements = (List)this.values_list.get(i);
                RowData row_data = this.insert_table.createRowDataObject(context);
                row_data.setupEntire(this.col_index_list, insert_elements, (QueryContext)context);
                this.insert_table.add(row_data);
                ++insert_count;
            }
        } else if (this.from_select) {
            Table result = this.prepared_select.evaluate();
            if (result.getColumnCount() != this.col_index_list.length) {
                throw new DatabaseException("Number of columns in result don't match columns to insert.");
            }
            IntegerVector row_list = new IntegerVector();
            RowEnumeration en = result.rowEnumeration();
            while (en.hasMoreRows()) {
                row_list.addInt(en.nextRowIndex());
            }
            int sz = row_list.size();
            for (int i = 0; i < sz; ++i) {
                int rindex = row_list.intAt(i);
                RowData row_data = this.insert_table.createRowDataObject(context);
                for (int n = 0; n < this.col_index_list.length; ++n) {
                    TObject cell = result.getCellContents(n, rindex);
                    row_data.setColumnData(this.col_index_list[n], cell);
                }
                row_data.setDefaultForRest(context);
                this.insert_table.add(row_data);
                ++insert_count;
            }
        } else if (this.from_set) {
            RowData row_data = this.insert_table.createRowDataObject(context);
            Assignment[] assignments = this.column_sets.toArray(new Assignment[this.column_sets.size()]);
            row_data.setupEntire(assignments, context);
            this.insert_table.add(row_data);
            ++insert_count;
        }
        if (insert_count > 0) {
            this.database.notifyTriggerEvent(new TriggerEvent(1, this.tname.toString(), insert_count));
        }
        return FunctionTable.resultTable(context, insert_count);
    }
}

